-- Minimal schema
CREATE TABLE IF NOT EXISTS rates (id INT AUTO_INCREMENT PRIMARY KEY, exchange VARCHAR(100), price_buy DECIMAL(18,6), price_sell DECIMAL(18,6), timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP);
CREATE TABLE IF NOT EXISTS trades (id INT AUTO_INCREMENT PRIMARY KEY, timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP, exchange VARCHAR(100), buy DECIMAL(18,6), sell DECIMAL(18,6), profit DECIMAL(18,6), roi DECIMAL(10,4));
CREATE TABLE IF NOT EXISTS profits (id INT AUTO_INCREMENT PRIMARY KEY, timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP, buyAmount DECIMAL(18,6) DEFAULT 100, bestBuyEx VARCHAR(100), bestBuyRate DECIMAL(18,6), bestSellEx VARCHAR(100), bestSellRate DECIMAL(18,6), totalProfit DECIMAL(18,6));
CREATE TABLE IF NOT EXISTS exchanges (id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(100) UNIQUE, enabled TINYINT(1) DEFAULT 1);
CREATE TABLE IF NOT EXISTS admins (id INT AUTO_INCREMENT PRIMARY KEY, username VARCHAR(100), email VARCHAR(255), password VARCHAR(255), role VARCHAR(50) DEFAULT 'admin', api_token VARCHAR(255), created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);
CREATE TABLE IF NOT EXISTS settings (k VARCHAR(100) PRIMARY KEY, v TEXT);
REPLACE INTO settings (k,v) VALUES ('profitThreshold','5000'),('emailAlerts','1');
