<?php
require_once __DIR__ . '/auth.php';
global $pdo;

$body = json_decode(file_get_contents('php://input'), true);
$username = trim($body['username'] ?? '');
$email = trim($body['email'] ?? '');
$password = $body['password'] ?? '';
$role = $body['role'] ?? 'admin';

if (!$username || !$password) {
    http_response_code(400);
    echo json_encode(['error' => 'username and password required']);
    exit;
}

$hash = password_hash($password, PASSWORD_BCRYPT);
$apiToken = bin2hex(random_bytes(20));

if ($pdo) {
    try {
        $stmt = $pdo->prepare('INSERT INTO admins (username,email,password,role,api_token,created_at) VALUES (?,?,?,?,?,NOW())');
        $stmt->execute([$username, $email, $hash, $role, $apiToken]);
        echo json_encode(['ok'=>true,'user'=>['username'=>$username,'email'=>$email,'api_token'=>$apiToken]]);
        exit;
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'DB insert failed: ' . $e->getMessage()]);
        exit;
    }
}

$uf = DATA_DIR . '/users.json';
$users = safe_read_json($uf);
$new = [
    'id' => time(),
    'username' => $username,
    'email' => $email,
    'password' => $hash,
    'role' => $role,
    'api_token' => $apiToken,
    'created_at' => date('c')
];
$users[] = $new;
safe_write_json($uf, $users);
echo json_encode(['ok'=>true,'user'=>['username'=>$username,'email'=>$email,'api_token'=>$apiToken]]);
?>