<?php
require_once __DIR__ . '/auth.php';

$profitsFile = DATA_DIR . '/profits.json';
$profits = safe_read_json($profitsFile);

$trend = [];
foreach ($profits as $p) {
    $trend[] = [
        'ts' => $p['timestamp'] ?? ($p['time'] ?? ''),
        'value' => isset($p['totalProfit']) ? floatval($p['totalProfit']) : (isset($p['profit']) ? floatval($p['profit']) : 0)
    ];
}

$bestProfit = 0;
foreach ($trend as $t) if ($t['value'] > $bestProfit) $bestProfit = $t['value'];

$response = [
    'bestProfit' => round($bestProfit, 2),
    'exchangeCount' => 4,
    'tradesCount' => count($profits),
    'lastUpdated' => count($profits) ? $profits[array_key_last($profits)]['timestamp'] : null,
    'trend' => array_slice($trend, -50)
];

echo json_encode($response);
?>