<?php
require_once __DIR__ . '/auth.php';

$body = json_decode(file_get_contents('php://input'), true);
$name = $body['name'] ?? null;
$enabled = isset($body['enabled']) ? boolval($body['enabled']) : null;

if (!$name || $enabled === null) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing name or enabled']);
    exit;
}

$exFile = DATA_DIR . '/exchanges.json';
$exchanges = safe_read_json($exFile);
if (empty($exchanges)) {
    $exchanges = [
        ['name'=>'Binance','enabled'=>true],
        ['name'=>'KuCoin','enabled'=>true],
        ['name'=>'Bybit','enabled'=>true],
        ['name'=>'Paxful','enabled'=>true],
        ['name'=>'Gate.io','enabled'=>true]
    ];
}

$found = false;
foreach ($exchanges as &$ex) {
    if (strcasecmp($ex['name'], $name) === 0) {
        $ex['enabled'] = $enabled;
        $found = true;
    }
}
if (!$found) $exchanges[] = ['name'=>$name,'enabled'=>$enabled];

safe_write_json($exFile, $exchanges);
echo json_encode(['ok'=>true,'name'=>$name,'enabled'=>$enabled]);
?>