const CACHE_NAME = 'arbitrage-cache-v2';

const urlsToCache = [
  './',
  './index.html',
  './dashboard.html',
  './manifest.json',
  './service-worker.js',
  './sw.js',
  './icons/icon-192.png',
  './icons/icon-512.png',
  './api/profits.json',
  './api/get_rates.php',
  './api/simulate.php',
  './api/trades.php',
  'https://cdn.tailwindcss.com',
  'https://cdn.jsdelivr.net/npm/chart.js'
];

// Install event: cache required assets
self.addEventListener('install', e => {
  e.waitUntil(
    caches.open(CACHE_NAME).then(cache => cache.addAll(urlsToCache))
  );
});

// Activate event: remove old caches
self.addEventListener('activate', e => {
  e.waitUntil(
    caches.keys().then(keys =>
      Promise.all(
        keys.map(key => {
          if (key !== CACHE_NAME) {
            return caches.delete(key);
          }
        })
      )
    )
  );
});

// Fetch event: respond from cache or fall back to network
self.addEventListener('fetch', e => {
  e.respondWith(
    caches.match(e.request).then(response => {
      return response || fetch(e.request).catch(() => {
        // fallback for navigation requests (if offline)
        if (e.request.mode === 'navigate') {
          return caches.match('./index.html');
        }
      });
    })
  );
});
