<?php
// Location: /scripts/weekly_summary.php
define('SUMMARY_EMAIL', 'you@example.com');

$file = __DIR__ . '/../profits.json';
$data = file_exists($file) ? json_decode(file_get_contents($file), true) : [];

$summary = [];
foreach ($data as $entry) {
    $ex = $entry['exchange'];
    $summary[$ex]['total'] = ($summary[$ex]['total'] ?? 0) + $entry['profit'];
    $summary[$ex]['count'] = ($summary[$ex]['count'] ?? 0) + 1;
}

$message = "📊 Weekly Profit Summary:\n\n";
foreach ($summary as $ex => $s) {
    $avg = $s['total'] / $s['count'];
    $message .= "🪙 $ex: ₦" . number_format($avg, 2) . " avg over {$s['count']} trades\n";
}

mail(SUMMARY_EMAIL, "Weekly Profit Summary", $message, "From: profits@yourdomain.com");
echo "Email sent.\n";
