<?php
// Location: /scripts/cron_archive_logs.php

$logDir = __DIR__ . '/../logs';
$archiveDir = $logDir . '/archive/' . date('Y-m-d');
if (!file_exists($archiveDir)) mkdir($archiveDir, 0775, true);

$logs = glob("$logDir/*.log");

foreach ($logs as $log) {
    $basename = basename($log);
    $destination = $archiveDir . '/' . $basename;

    // Move log
    if (rename($log, $destination)) {
        echo "Archived: $basename\n";
    }
}

// Optional: compress
$zipFile = $archiveDir . '.zip';
$zip = new ZipArchive();
if ($zip->open($zipFile, ZipArchive::CREATE) === true) {
    foreach (glob("$archiveDir/*.log") as $file) {
        $zip->addFile($file, basename($file));
    }
    $zip->close();

    // Remove original files after zipping
    foreach (glob("$archiveDir/*.log") as $file) {
        unlink($file);
    }
    rmdir($archiveDir); // remove empty dir
    echo "Compressed into: $zipFile\n";
}
