<?php
// Location: /scripts/analyze_profits.php

$file = __DIR__ . '/../profits.json';
if (!file_exists($file)) exit("No profit data found.\n");

$data = json_decode(file_get_contents($file), true);
if (!$data || !is_array($data)) exit("Invalid JSON format.\n");

$summary = [];
foreach ($data as $entry) {
    $ex = $entry['exchange'];
    if (!isset($summary[$ex])) {
        $summary[$ex] = [
            'total_profit' => 0,
            'count' => 0,
            'max' => $entry['profit'],
            'min' => $entry['profit']
        ];
    }

    $summary[$ex]['total_profit'] += $entry['profit'];
    $summary[$ex]['count']++;
    $summary[$ex]['max'] = max($summary[$ex]['max'], $entry['profit']);
    $summary[$ex]['min'] = min($summary[$ex]['min'], $entry['profit']);
}

// Output summary
foreach ($summary as $ex => $stats) {
    $avg = $stats['total_profit'] / $stats['count'];
    echo "📊 Exchange: $ex\n";
    echo " - Average Profit: ₦" . number_format($avg, 2) . "\n";
    echo " - Max Profit: ₦" . number_format($stats['max'], 2) . "\n";
    echo " - Min Profit: ₦" . number_format($stats['min'], 2) . "\n";
    echo " - Trades Count: {$stats['count']}\n\n";
}
