// auth.js - token handling
const ADMIN_TOKEN_KEY = 'adminToken';
export function getToken() { return localStorage.getItem(ADMIN_TOKEN_KEY) || ''; }
export function setToken(t) { if (t) localStorage.setItem(ADMIN_TOKEN_KEY, t); else localStorage.removeItem(ADMIN_TOKEN_KEY); }
export function authFetch(url, opts = {}) {
  opts.headers = opts.headers || {};
  const token = getToken();
  if (token) opts.headers['Authorization'] = 'Bearer ' + token;
  return fetch(url, opts).then(async res => {
    if (res.status === 401) { window.location.href = 'index.html'; throw new Error('Unauthorized'); }
    return res;
  });
}
