<?php
require_once __DIR__ . '/auth.php';

$page = max(1, intval($_GET['page'] ?? 1));
$pageSize = max(10, intval($_GET['pageSize'] ?? 25));
$q = trim($_GET['q'] ?? '');
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';

$tradesFile = DATA_DIR . '/trades.json';
$trades = safe_read_json($tradesFile);

if (empty($trades)) {
    $p = safe_read_json(DATA_DIR . '/profits.json');
    foreach ($p as $entry) {
        $trades[] = [
            'timestamp' => $entry['timestamp'] ?? ($entry['time'] ?? ''),
            'exchange' => $entry['topExchange'] ?? ($entry['exchange'] ?? ''),
            'buy' => $entry['buy'] ?? 0,
            'sell' => $entry['sell'] ?? 0,
            'profit' => $entry['totalProfit'] ?? ($entry['profit'] ?? 0)
        ];
    }
}

$filtered = array_values(array_filter($trades, function($t) use ($q, $from, $to) {
    if ($q) {
        $hay = strtolower(json_encode($t));
        if (strpos($hay, strtolower($q)) === false) return false;
    }
    if ($from && isset($t['timestamp']) && strtotime($t['timestamp']) < strtotime($from . ' 00:00:00')) return false;
    if ($to && isset($t['timestamp']) && strtotime($t['timestamp']) > strtotime($to . ' 23:59:59')) return false;
    return true;
}));

$total = count($filtered);
$items = array_slice($filtered, ($page - 1) * $pageSize, $pageSize);

echo json_encode([
    'page' => $page,
    'pageSize' => $pageSize,
    'total' => $total,
    'items' => $items
]);
?>