<?php
require_once __DIR__ . '/auth.php';

$settingsFile = DATA_DIR . '/settings_alerts.json';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $body = json_decode(file_get_contents('php://input'), true);
    $s = safe_read_json($settingsFile);
    if (isset($body['profitThreshold'])) $s['profitThreshold'] = floatval($body['profitThreshold']);
    if (isset($body['emailAlerts'])) $s['emailAlerts'] = boolval($body['emailAlerts']);
    safe_write_json($settingsFile, $s);
    echo json_encode(['ok' => true, 'settings' => $s]);
    exit;
}

$s = safe_read_json($settingsFile);
if (!isset($s['profitThreshold'])) $s['profitThreshold'] = 5000;
if (!isset($s['emailAlerts'])) $s['emailAlerts'] = true;
echo json_encode($s);
?>