<?php
require_once __DIR__ . '/auth.php';

$files = [
    'alerts' => LOG_DIR . '/alerts.log',
    'activity' => LOG_DIR . '/admin_activity.log',
    'errors' => LOG_DIR . '/errors.log'
];

$out = [];
foreach ($files as $key => $path) {
    if (file_exists($path)) {
        $text = file_get_contents($path);
        $lines = array_filter(array_map('trim', explode("\n", $text)));
        $out[$key] = array_slice($lines, -200);
    } else {
        $out[$key] = [];
    }
}

echo json_encode($out);
?>