<?php
// admin_api/config.php
declare(strict_types=1);

// ------------- EDIT THESE -------------
define('AUTH_TOKEN', 'REPLACE_WITH_A_LONG_RANDOM_TOKEN'); // static token fallback
define('DB_HOST', '127.0.0.1');
define('DB_NAME', '');   // set your DB name
define('DB_USER', '');   // set DB user
define('DB_PASS', '');   // set DB password
// --------------------------------------

define('DATA_DIR', __DIR__ . '/data');
define('LOG_DIR', __DIR__ . '/logs');

if (!is_dir(DATA_DIR)) mkdir(DATA_DIR, 0755, true);
if (!is_dir(LOG_DIR)) mkdir(LOG_DIR, 0755, true);

$pdo = null;
if (DB_NAME && DB_USER) {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $pdo = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
    } catch (Exception $e) {
        error_log('DB connect failed: ' . $e->getMessage());
        $pdo = null;
    }
}

function safe_read_json(string $path): array {
    if (!file_exists($path)) return [];
    $txt = file_get_contents($path);
    $j = json_decode($txt, true);
    return is_array($j) ? $j : [];
}

function safe_write_json(string $path, array $data): bool {
    return (bool) file_put_contents($path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), LOCK_EX);
}
?>