<?php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json');

$headers = function_exists('getallheaders') ? getallheaders() : [];
$authHeader = $headers['Authorization'] ?? $headers['authorization'] ?? '';
$token = '';

if ($authHeader) {
    if (stripos($authHeader, 'Bearer ') === 0) $token = trim(substr($authHeader, 7));
    else $token = trim($authHeader);
}
if (!$token) $token = trim($_GET['token'] ?? '');

if (defined('AUTH_TOKEN') && AUTH_TOKEN && hash_equals(AUTH_TOKEN, $token)) {
    return;
}

global $pdo;
if ($pdo) {
    try {
        $stmt = $pdo->prepare('SELECT id, username, role FROM admins WHERE api_token = ? LIMIT 1');
        $stmt->execute([$token]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($user) {
            $GLOBALS['admin_user'] = $user;
            return;
        }
        $stmt2 = $pdo->prepare('SELECT id, username, role FROM users WHERE api_token = ? LIMIT 1');
        $stmt2->execute([$token]);
        $user2 = $stmt2->fetch(PDO::FETCH_ASSOC);
        if ($user2) {
            $GLOBALS['admin_user'] = $user2;
            return;
        }
    } catch (Exception $e) {
        // fall back to file-based
    }
}

// file fallback
$users = safe_read_json(__DIR__ . '/data/users.json');
foreach ($users as $u) {
    if (isset($u['api_token']) && hash_equals($u['api_token'], $token)) {
        $GLOBALS['admin_user'] = $u;
        return;
    }
}

http_response_code(401);
echo json_encode(['error' => 'Unauthorized: invalid token']);
exit;
?>