-- RATES: Store current buy/sell rates from each exchange
CREATE TABLE IF NOT EXISTS rates (
    id INT AUTO_INCREMENT PRIMARY KEY,
    exchange VARCHAR(100),
    price_buy DECIMAL(18,6),
    price_sell DECIMAL(18,6),
    timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- TRADES: Every executed trade (manual or simulated)
CREATE TABLE IF NOT EXISTS trades (
    id INT AUTO_INCREMENT PRIMARY KEY,
    timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    exchange VARCHAR(100),
    buy DECIMAL(18,6),
    sell DECIMAL(18,6),
    profit DECIMAL(18,6),
    roi DECIMAL(10,4),
    trade_type ENUM('simulation','live') DEFAULT 'simulation',  -- NEW: track type
    ai_prediction JSON                                             -- NEW: store AI prediction data for trade
);

-- PROFITS: Daily or hourly profit tracking
CREATE TABLE IF NOT EXISTS profits (
    id INT AUTO_INCREMENT PRIMARY KEY,
    timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    buyAmount DECIMAL(18,6) DEFAULT 100,
    bestBuyEx VARCHAR(100),
    bestBuyRate DECIMAL(18,6),
    bestSellEx VARCHAR(100),
    bestSellRate DECIMAL(18,6),
    totalProfit DECIMAL(18,6),
    roi DECIMAL(10,4) DEFAULT 0.0000                                -- NEW: store ROI for the period
);

-- EXCHANGES: Store exchange list, status, and API keys
CREATE TABLE IF NOT EXISTS exchanges (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) UNIQUE,
    enabled TINYINT(1) DEFAULT 1,
    api_key TEXT,                                                  -- NEW: API Key storage
    api_secret TEXT,                                               -- NEW: Secret storage
    passphrase TEXT,                                               -- NEW: For exchanges like KuCoin/Bybit
    extra_config JSON                                               -- NEW: For optional config (webhooks, rate limits)
);

-- ADMINS: Admin accounts and API tokens
CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100),
    email VARCHAR(255),
    password VARCHAR(255),
    role VARCHAR(50) DEFAULT 'admin',
    api_token VARCHAR(255),
    last_login TIMESTAMP NULL,                                     -- NEW: Track last login
    ip_whitelist TEXT,                                             -- NEW: Optional IP whitelist for security
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- SETTINGS: Arbitrary system settings
CREATE TABLE IF NOT EXISTS settings (
    k VARCHAR(100) PRIMARY KEY,
    v TEXT
);

-- Default settings insert
REPLACE INTO settings (k,v) VALUES
    ('profitThreshold','5000'),
    ('emailAlerts','1'),
    ('defaultTradeAmount','100'),                                  -- NEW: Default live trade amount
    ('allowedExchanges','binance,kucoin,gateio,bybit,bpax,luno'),  -- NEW: Enabled exchanges list
    ('aiPredictionsEnabled','1'),                                  -- NEW: Toggle AI predictions
    ('ipWhitelistEnabled','0');                                    -- NEW: Toggle IP whitelist feature
